/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_mult ( result, dataa, datab, sum, clock ) ;

  parameter lpm_type       = "lpm_mult" ;
  parameter lpm_widtha     = 1 ;
  parameter lpm_widthb     = 1 ;
  parameter lpm_widths     = 1 ;
  parameter lpm_widthp     = 1 ;
  parameter latency    = 0 ;
  parameter lpm_rep  = "UNSIGNED" ;
  parameter polar_dataa    = "NORMAL" ;
  parameter polar_datab    = "NORMAL" ;
  parameter polar_sum      = "NORMAL" ;
  parameter polar_result   = "NORMAL" ;
  parameter polar_clock   = "NORMAL" ;

  input  clock ;
  input  [lpm_widtha-1:0] dataa ;
  input  [lpm_widthb-1:0] datab ;
  input  [lpm_widths-1:0] sum ;
  output [lpm_widthp-1:0] result;

  // inernal reg
  reg   [lpm_widthp-1:0] tmp_result ;
  reg   [lpm_widthp-1:0] tmp_result2 [latency:0];
  reg   [lpm_widtha-1:0] pdataa ;
  reg   [lpm_widthb-1:0] pdatab ;
  reg   [lpm_widths-1:0] psum ;
  reg   [lpm_widths-1:0] pclock ;
  reg   [lpm_widthp-1:0] ONES, UNKNOWN, HiZ ;
  integer i, maxs_mn ;
  integer int_dataa, int_datab, int_sum, int_result ;

  initial
  begin

	// check if latency is > 1 and clock is not used 
	if((latency >=1 ) && (clock === 1'bz) )
		$display("%t: Error! The clock pin is requied if latency is used\n", $time) ;
	else if((latency == 0 ) && (clock !== 1'bz) )
		$display("%t: Error! If the clock pin is used, latency must be greater than 0.\n", $time) ;
	

	if(sum[0] === 1'bz)
	// initialize psum if the sum is not used 
		psum = 0 ;
    
	for(i=0; i < lpm_widthp; i=i+1)
	  begin
        ONES[i] = 1'b1 ;
        UNKNOWN[i] = 1'bx ;
        HiZ[i] = 1'bz ;
	  end


	// get the length of the result output pin 
	maxs_mn = ((lpm_widtha+lpm_widthb)>lpm_widths)?lpm_widtha+lpm_widthb:lpm_widths ;
  end

  always @(clock )
  begin
    pclock  <= #1 (polar_clock == "INVERT")?~clock:clock;
  end

  always @( sum )
  begin
    psum  <= #1 (polar_sum == "INVERT")?~sum:sum;
  end

  always @(dataa)
  begin
    pdataa <= #1 (polar_dataa == "INVERT")?~dataa:dataa;
  end
  
  always @( datab )
  begin
    pdatab <= #1 (polar_datab == "INVERT")?~datab:datab;
  end

  always @(pdataa or pdatab or psum)
    begin
      if (lpm_rep == "UNSIGNED")
        begin
		  int_dataa = pdataa ;
		  int_datab = pdatab ;
		  int_sum = psum ;
        end
      else if (lpm_rep == "SIGNED")
        begin
		  // convert signed pdataa
          if(pdataa[lpm_widtha-1] == 1)
          begin
            int_dataa = 0 ;
            for(i = 0; i < lpm_widtha - 1; i = i + 1)
                int_dataa[i] = pdataa[i] ^ 1;
            int_dataa = -(int_dataa + 1) ;
          end
          else int_dataa = dataa ;

		  // convert signed pdatab
          if(pdatab[lpm_widthb-1] == 1)
          begin
            int_datab = 0 ;
            for(i = 0; i < lpm_widthb - 1; i = i + 1)
                int_datab[i] = pdatab[i] ^ 1;
            int_datab = -(int_datab + 1) ;
          end
          else int_datab = datab ;

		  // convert signed psum
          if(psum[lpm_widths-1] == 1)
          begin
            int_sum = 0 ;
            for(i = 0; i < lpm_widtha - 1; i = i + 1)
                int_sum[i] = psum[i] ^ 1;
            int_sum = -(int_sum + 1) ;
          end
          else int_sum = psum ;
		end
      else 
        begin
		  int_dataa = UNKNOWN ;
		  int_datab = UNKNOWN ;
		  int_sum   = UNKNOWN ;
        end

	  int_result = int_dataa * int_datab + int_sum ;
	  if(lpm_widthp >= maxs_mn)
		tmp_result = int_result ;
	  else
		begin
			for(i = 0; i < lpm_widthp; i = i +1)
				tmp_result[lpm_widthp-1-i] = int_result[maxs_mn-1-i] ;
		end	
	  tmp_result2[latency] = tmp_result ;
		
	end

	always @(posedge pclock)
	begin
		for(i = 0; i < latency; i = i +1)
			tmp_result2[i] = tmp_result2[i+1] ;
	end

  assign result = (polar_result == "INVERT")? ~tmp_result2[0]:tmp_result2[0] ;

 endmodule // lpm_mult
`ifdef SYNTH
`else
`endcelldefine
`endif

